/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.block;

import com.jsblock.BlockEntityTypes;
import com.jsblock.JobanMapping;
import com.jsblock.packet.Server;
import mtr.MTR;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class SoundLooper
extends class_2248
implements EntityBlockMapper {
    public SoundLooper(class_4970.class_2251 settings) {
        super(settings);
    }

    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntitySoundLooper(pos, state);
    }

    public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
        TileEntitySoundLooper.tick(world, pos, blockEntity);
    }

    public class_2591<? extends BlockEntityMapper> getType() {
        return (class_2591)BlockEntityTypes.SOUND_LOOPER_TILE_ENTITY.get();
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        return IBlock.checkHoldingBrush((class_1937)world, (class_1657)player, () -> {
            class_2586 entity = world.method_8321(pos);
            if (entity instanceof TileEntitySoundLooper) {
                Server.openSoundLooperScreenS2C((class_3222)player, pos);
            }
        });
    }

    public static class TileEntitySoundLooper
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private String soundID = "";
        private class_2338 pos1 = new class_2338(0, 0, 0);
        private class_2338 pos2 = new class_2338(0, 0, 0);
        private int repeatTick = 20;
        private float soundVolume = 1.0f;
        private int soundCategory = 0;
        private boolean requireRedstone = false;
        private boolean limitRange = false;
        private final String KEY_REPEAT_TICK = "repeat_tick";
        private final String KEY_SOUND_ID = "sound_id";
        private final String KEY_SOUND_CATEGORY = "sound_category";
        private final String KEY_NEED_REDSTONE = "need_redstone";
        private final String KEY_SOUND_VOLUME = "volume";
        private final String KEY_POS1 = "pos_1";
        private final String KEY_POS2 = "pos_2";
        private final String KEY_LIMIT_RANGE = "limit_range";
        private static final class_3419[] SOURCE_LIST = new class_3419[]{class_3419.field_15250, class_3419.field_15253, class_3419.field_15252, class_3419.field_15256, class_3419.field_15248};

        public TileEntitySoundLooper(class_2338 pos, class_2680 state) {
            super((class_2591)BlockEntityTypes.SOUND_LOOPER_TILE_ENTITY.get(), pos, state);
        }

        public void readCompoundTag(class_2487 compoundTag) {
            this.repeatTick = compoundTag.method_10550("repeat_tick");
            this.soundID = compoundTag.method_10558("sound_id");
            this.soundCategory = compoundTag.method_10550("sound_category");
            this.soundVolume = compoundTag.method_10583("volume");
            this.requireRedstone = compoundTag.method_10577("need_redstone");
            this.requireRedstone = compoundTag.method_10577("need_redstone");
            this.limitRange = compoundTag.method_10577("limit_range");
            this.pos1 = class_2338.method_10092((long)compoundTag.method_10537("pos_1"));
            this.pos2 = class_2338.method_10092((long)compoundTag.method_10537("pos_2"));
        }

        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10569("repeat_tick", this.repeatTick);
            compoundTag.method_10582("sound_id", this.soundID);
            compoundTag.method_10569("sound_category", this.soundCategory);
            compoundTag.method_10548("volume", this.soundVolume);
            compoundTag.method_10556("need_redstone", this.requireRedstone);
            compoundTag.method_10556("limit_range", this.limitRange);
            compoundTag.method_10544("pos_1", this.pos1.method_10063());
            compoundTag.method_10544("pos_2", this.pos2.method_10063());
        }

        public void tick() {
            TileEntitySoundLooper.tick(this.field_11863, this.field_11867, (class_2586)this);
        }

        public static <T extends BlockEntityClientSerializableMapper> void tick(class_1937 level, class_2338 pos, class_2586 entity) {
            if (!(entity instanceof TileEntitySoundLooper)) {
                return;
            }
            int repeatTick = ((TileEntitySoundLooper)entity).getLoopInterval();
            int soundCategory = ((TileEntitySoundLooper)entity).getSoundCategory();
            float soundVolume = ((TileEntitySoundLooper)entity).getSoundVolume();
            boolean requireRedstone = ((TileEntitySoundLooper)entity).getNeedRedstone();
            boolean limitRange = ((TileEntitySoundLooper)entity).getLimitRange();
            String soundID = ((TileEntitySoundLooper)entity).getSoundId();
            class_2338 pos1 = ((TileEntitySoundLooper)entity).getPos1();
            class_2338 pos2 = ((TileEntitySoundLooper)entity).getPos2();
            class_238 box = new class_238(pos1, pos2);
            if (repeatTick > 0 && MTR.isGameTickInterval((int)repeatTick) && !soundID.isEmpty()) {
                if (level.method_8608()) {
                    return;
                }
                if (requireRedstone && !level.method_8479(pos)) {
                    return;
                }
                if (!limitRange) {
                    level.method_18456().forEach(player -> {
                        try {
                            class_2960 soundLocation = new class_2960(soundID);
                            class_3419 source = SOURCE_LIST[soundCategory];
                            long seed = level.method_8409().method_43055();
                            JobanMapping.sendSoundToPlayer(level, (class_3222)player, soundLocation, source, pos, soundVolume);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                } else {
                    level.method_18467(class_1657.class, box).forEach(player -> {
                        try {
                            class_2960 soundLocation = new class_2960(soundID);
                            class_3419 source = SOURCE_LIST[soundCategory];
                            JobanMapping.sendSoundToPlayer(level, (class_3222)player, soundLocation, source, pos, soundVolume);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
        }

        public String getSoundId() {
            return this.soundID == null ? "" : this.soundID;
        }

        public int getLoopInterval() {
            return this.repeatTick;
        }

        public int getSoundCategory() {
            if (this.soundCategory > SOURCE_LIST.length) {
                this.soundCategory = 0;
            }
            return this.soundCategory;
        }

        public void setData(String soundId, int soundCategory, int interval, float volume, boolean requireRedstone, boolean limitRange, class_2338 pos1, class_2338 pos2) {
            this.soundID = soundId;
            this.repeatTick = interval;
            this.soundCategory = soundCategory;
            this.soundVolume = volume;
            this.requireRedstone = requireRedstone;
            this.pos1 = pos1;
            this.pos2 = pos2;
            this.limitRange = limitRange;
            this.syncData();
        }

        public float getSoundVolume() {
            return this.soundVolume;
        }

        public boolean getNeedRedstone() {
            return this.requireRedstone;
        }

        public boolean getLimitRange() {
            return this.limitRange;
        }

        public class_2338 getPos1() {
            return this.pos1;
        }

        public class_2338 getPos2() {
            return this.pos2;
        }
    }
}

