/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.block;

import com.jsblock.BlockEntityTypes;
import com.jsblock.Joban;
import com.jsblock.packet.Server;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_267;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class SubsidyMachine1
extends class_2383
implements EntityBlockMapper {
    private final Map<UUID, Integer> timeouts = new HashMap<UUID, Integer>();

    public SubsidyMachine1(class_4970.class_2251 settings) {
        super(settings);
    }

    public class_265 method_9530(class_2680 state, class_1922 blockGetter, class_2338 pos, class_3726 collisionContext) {
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)0.0, (double)14.0, (double)18.0, (double)3.0, (class_2350)((class_2350)state.method_11654((class_2769)field_11177)));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 collisionContext) {
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)3.0, (class_2350)((class_2350)state.method_11654((class_2769)field_11177)));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (!world.method_8608()) {
            UUID playerUUID = player.method_5667();
            class_2586 entity = world.method_8321(pos);
            TicketSystem.addObjectivesIfMissing((class_1937)world);
            IBlock.checkHoldingBrush((class_1937)world, (class_1657)player, () -> {
                if (entity instanceof TileEntitySubsidyMachine) {
                    Server.openSubsidyConfigScreenS2C((class_3222)player, pos, ((TileEntitySubsidyMachine)entity).getPricePerClick(), ((TileEntitySubsidyMachine)entity).getTimeout());
                }
            }, () -> {
                if (entity instanceof TileEntitySubsidyMachine) {
                    int subsidyPrice = ((TileEntitySubsidyMachine)entity).getPricePerClick();
                    int timeoutTick = ((TileEntitySubsidyMachine)entity).getTimeout() * 20;
                    if (this.timeouts.containsKey(playerUUID)) {
                        int timeoutLeft = this.timeouts.get(playerUUID) - Joban.getGameTick();
                        if (timeoutLeft <= 0) {
                            this.timeouts.remove(playerUUID);
                        } else {
                            player.method_7353((class_2561)Text.translatable((String)"gui.jsblock.subsidy_timeout", (Object[])new Object[]{timeoutLeft / 20}), true);
                            return;
                        }
                    }
                    class_267 balanceScore = TicketSystem.getPlayerScore((class_1937)world, (class_1657)player, (String)"mtr_balance");
                    balanceScore.method_1128(balanceScore.method_1126() + subsidyPrice);
                    player.method_7353((class_2561)Text.translatable((String)"gui.jsblock.subsidy", (Object[])new Object[]{subsidyPrice, balanceScore.method_1126()}), true);
                    this.timeouts.put(playerUUID, Joban.getGameTick() + timeoutTick);
                }
            });
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    public class_2591<? extends BlockEntityMapper> getType() {
        return (class_2591)BlockEntityTypes.SUBSIDY_MACHINE_TILE_ENTITY_1.get();
    }

    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntitySubsidyMachine(pos, state);
    }

    public static class TileEntitySubsidyMachine
    extends BlockEntityMapper {
        private int pricePerClick = 10;
        private int timeout = 0;
        private static final String KEY_PRICE_PER_CLICK = "price_per_click";
        private static final String KEY_TIMEOUT = "timeout";

        public TileEntitySubsidyMachine(class_2338 pos, class_2680 state) {
            super((class_2591)BlockEntityTypes.SUBSIDY_MACHINE_TILE_ENTITY_1.get(), pos, state);
        }

        public void readCompoundTag(class_2487 compoundTag) {
            this.pricePerClick = compoundTag.method_10550(KEY_PRICE_PER_CLICK);
            this.timeout = compoundTag.method_10550(KEY_TIMEOUT);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10569(KEY_PRICE_PER_CLICK, this.pricePerClick);
            compoundTag.method_10569(KEY_TIMEOUT, this.timeout);
        }

        public void setData(int pricePerClick, int timeout) {
            this.pricePerClick = pricePerClick;
            this.timeout = timeout;
            this.method_5431();
        }

        public int getPricePerClick() {
            return this.pricePerClick;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }
}

