/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jsblock.Joban;
import com.jsblock.data.PIDSPreset;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.function.Consumer;
import mtr.mappings.Utilities;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class JobanCustomResources {
    public static HashMap<String, PIDSPreset> PIDSPreset = new HashMap();
    private static final PIDSPreset defaultPreset1 = new PIDSPreset(new class_2960("jsblock", "textures/pids_screen/door_cls_apg.png"), true, true, true, null, null);
    private static final PIDSPreset defaultPreset2 = new PIDSPreset(new class_2960("jsblock", "textures/pids_screen/door_cls_psd.png"), true, true, true, null, null);
    private static final PIDSPreset defaultPreset3 = new PIDSPreset(new class_2960("jsblock", "textures/pids_screen/door_cls_train.png"), true, true, true, null, null);
    public static final String CUSTOM_RESOURCES_ID = "joban_custom_resources";
    public static final String customResourcePath = "jsblock:joban_custom_resources.json";
    public static final String backupCustomResourcePath = "mtr:joban_custom_resources.json";

    public static void reload(class_3300 resourceManager) {
        PIDSPreset.clear();
        PIDSPreset.put("door_cls_apg", defaultPreset1);
        PIDSPreset.put("door_cls_psd", defaultPreset2);
        PIDSPreset.put("door_cls_train", defaultPreset3);
        JobanCustomResources.readResource(resourceManager, customResourcePath, jsonConfig -> {
            try {
                jsonConfig.get("pids_images").getAsJsonArray().forEach(jsonElement -> {
                    String id = jsonElement.getAsJsonObject().get("id").getAsString();
                    boolean showWeather = jsonElement.getAsJsonObject().get("showWeather").getAsBoolean();
                    boolean showClock = jsonElement.getAsJsonObject().get("showClock").getAsBoolean();
                    String fonts = jsonElement.getAsJsonObject().has("fonts") ? jsonElement.getAsJsonObject().get("fonts").getAsString() : null;
                    String color = jsonElement.getAsJsonObject().has("color") ? jsonElement.getAsJsonObject().get("color").getAsString() : null;
                    class_2960 loc = new class_2960(jsonElement.getAsJsonObject().get("background").getAsString());
                    if (PIDSPreset.containsKey(id)) {
                        Joban.LOGGER.warn("[Joban Client] PIDS Preset ID: " + id + " already added.");
                        return;
                    }
                    Integer actualColor = null;
                    if (color != null) {
                        actualColor = Integer.parseInt(color, 16);
                    }
                    PIDSPreset.put(id, new PIDSPreset(loc, showWeather, showClock, false, actualColor, fonts));
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        JobanCustomResources.readResource(resourceManager, backupCustomResourcePath, jsonConfig -> {
            try {
                jsonConfig.get("rv_pids_images").getAsJsonArray().forEach(jsonElement -> {
                    String id = jsonElement.getAsJsonObject().get("id").getAsString();
                    boolean showWeather = jsonElement.getAsJsonObject().get("showWeather").getAsBoolean();
                    boolean showClock = jsonElement.getAsJsonObject().get("showClock").getAsBoolean();
                    String fonts = jsonElement.getAsJsonObject().has("fonts") ? jsonElement.getAsJsonObject().get("fonts").getAsString() : null;
                    String color = jsonElement.getAsJsonObject().has("color") ? jsonElement.getAsJsonObject().get("color").getAsString() : null;
                    class_2960 loc = new class_2960(jsonElement.getAsJsonObject().get("location").getAsString());
                    if (PIDSPreset.containsKey(id)) {
                        Joban.LOGGER.warn("[Joban Client] PIDS Preset ID: " + id + " already added.");
                        return;
                    }
                    Integer actualColor = null;
                    if (color != null) {
                        actualColor = Integer.parseInt(color, 16);
                    }
                    PIDSPreset.put(id, new PIDSPreset(loc, showWeather, showClock, false, actualColor, fonts));
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Joban.LOGGER.info("[Joban Client] Loaded PIDS Preset: " + String.join((CharSequence)", ", PIDSPreset.keySet()));
    }

    private static void readResource(class_3300 manager, String path, Consumer<JsonObject> callback) {
        try {
            UtilitiesClient.getResources((class_3300)manager, (class_2960)new class_2960(path)).forEach(resource -> {
                try (InputStream stream = Utilities.getInputStream((class_3298)resource);){
                    callback.accept(new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Utilities.closeResource((class_3298)resource);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

