/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jsblock.Joban;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;

public class ClientConfig {
    private static final String CONFIG_PATH = System.getProperty("user.dir") + "/config/jsclient.json";
    private static boolean renderDisabled = false;
    private static boolean bypassVersionCheck = false;
    private static boolean debugMode = false;

    public static void loadConfig() {
        if (!Files.exists(Paths.get(CONFIG_PATH, new String[0]), new LinkOption[0])) {
            Joban.LOGGER.warn("[Joban Client] Config file not found, generating one...");
            try {
                ClientConfig.writeConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        Joban.LOGGER.info("[Joban Client] Reading Config...");
        try {
            JsonObject jsonConfig = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(Paths.get(CONFIG_PATH, new String[0])))).getAsJsonObject();
            if (jsonConfig.has("renderDisabled")) {
                renderDisabled = jsonConfig.get("renderDisabled").getAsBoolean();
            }
            if (jsonConfig.has("bypassVersionCheck")) {
                bypassVersionCheck = jsonConfig.get("bypassVersionCheck").getAsBoolean();
            }
            if (jsonConfig.has("debugMode")) {
                debugMode = jsonConfig.get("debugMode").getAsBoolean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                ClientConfig.writeConfig();
            }
            catch (Exception er) {
                er.printStackTrace();
            }
        }
    }

    public static void writeConfig() throws IOException {
        Joban.LOGGER.info("[Joban Client] Writing Config...");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty("renderDisabled", Boolean.valueOf(renderDisabled));
        jsonConfig.addProperty("bypassVersionCheck", Boolean.valueOf(bypassVersionCheck));
        jsonConfig.addProperty("debugMode", Boolean.valueOf(debugMode));
        try {
            Files.write(Paths.get(CONFIG_PATH, new String[0]), Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static boolean getRenderDisabled() {
        return renderDisabled;
    }

    public static boolean getVersionCheckDisabled() {
        return bypassVersionCheck;
    }

    public static boolean getDebugModeEnabled() {
        return debugMode;
    }

    public static boolean setRenderDisabled(boolean disabled) {
        renderDisabled = disabled;
        return renderDisabled;
    }

    public static boolean setDebugMode(boolean enabled) {
        debugMode = enabled;
        return debugMode;
    }

    public static boolean setVersionCheckDisabled(boolean disabled) {
        bypassVersionCheck = disabled;
        return bypassVersionCheck;
    }
}

