/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.render;

import com.jsblock.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import net.minecraft.class_1160;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_824;

public class RenderDepartureTimer<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    private static final String FONT_NAME = "jsblock:deptimer";

    public RenderDepartureTimer(class_824 dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        class_2338 pos = entity.method_11016();
        if (world == null || ClientConfig.getRenderDisabled()) {
            return;
        }
        long platformId = RailwayData.getClosePlatformId((Set)ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE, (class_2338)pos, (int)5, (int)3, (int)3);
        if (platformId == 0L) {
            return;
        }
        Set schedules = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platformId);
        if (schedules == null) {
            return;
        }
        String timeRemaining = "";
        ArrayList scheduleList = new ArrayList(schedules);
        if (!scheduleList.isEmpty()) {
            Collections.sort(scheduleList);
            if (((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis() > 0L) {
                return;
            }
            int remainingSecond = (int)(((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000;
            Platform platform = (Platform)ClientData.DATA_CACHE.platformIdMap.get(platformId);
            int seconds = platform == null ? 0 : Math.abs(platform.getDwellTime() / 2 - Math.abs(remainingSecond));
            int minutes = seconds / 60;
            timeRemaining = String.format("%d:%02d", minutes % 60, seconds % 60);
        }
        class_2583 style = Config.useMTRFont() ? class_2583.field_24360.method_27704(new class_2960(FONT_NAME)) : class_2583.field_24360;
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, (class_2338)pos, (class_2769)class_2383.field_11177);
        matrices.method_22903();
        if (facing == class_2350.field_11035) {
            matrices.method_22904(0.73, 0.52, 0.43);
        }
        if (facing == class_2350.field_11043) {
            matrices.method_22904(0.28, 0.52, 0.57);
        }
        if (facing == class_2350.field_11034) {
            matrices.method_22904(0.43, 0.52, 0.28);
        }
        if (facing == class_2350.field_11039) {
            matrices.method_22904(0.57, 0.52, 0.73);
        }
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
        matrices.method_22907(class_1160.field_20705.method_23214(facing.method_10144()));
        matrices.method_22905(0.018f, 0.018f, 0.018f);
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_5250 formattedText = Text.literal((String)timeRemaining).method_10862(style);
        textRenderer.method_30883(matrices, (class_2561)formattedText, 0.0f, 0.0f, 0xEE2233);
        matrices.method_22909();
    }
}

