/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.render;

import com.jsblock.data.PIDSPreset;
import com.jsblock.render.RenderPIDSBase;
import com.jsblock.screen.IDrawingJoban;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.IBlock;
import mtr.client.ClientCache;
import mtr.client.ClientData;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Text;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1160;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_824;

public class RenderLCDPIDS<T extends BlockEntityMapper>
extends RenderPIDSBase<T>
implements IGui {
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final int maxArrivals;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final boolean showPlatforms;
    private final float screenWidth;
    private final float rotation;
    private final int defaultTextColor;
    private static final String defaultFont = "jsblock:pids_lcd";
    private final float BACKGROUND_WIDTH = 111.0f;
    private final float BACKGROUND_HEIGHT = 60.0f;
    private final PIDSPreset DEFAULT_PRESET = new PIDSPreset(null, false, false, false, null, null);
    private List<ClientCache.PlatformRouteDetails> routeData;

    public RenderLCDPIDS(class_824 dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, boolean showPlatforms, int defaultTextColor, float rotation) {
        super(dispatcher, maxArrivals);
        this.scale = (float)(230 * maxArrivals) / maxHeight;
        this.totalScaledWidth = this.scale * (float)maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        this.destinationMaxWidth = this.totalScaledWidth * 0.33f;
        this.platformMaxWidth = showPlatforms ? this.scale * 2.0f / 16.0f : 0.0f;
        this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
        this.screenWidth = this.arrivalMaxWidth / 1.35f;
        this.maxArrivals = maxArrivals;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.showPlatforms = showPlatforms;
        this.rotation = rotation;
        this.defaultTextColor = defaultTextColor;
    }

    @Override
    public void render(T entity, class_1937 world, String[] customMessages, boolean[] hideArrivals, boolean hidePlatforms, PIDSPreset preset, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2338 pos = entity.method_11016();
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, (class_2338)pos, (class_2769)class_2383.field_11177);
        PIDSPreset pidsPreset = preset == null ? this.DEFAULT_PRESET : preset;
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22907(class_1160.field_20705.method_23214((float)(this.rotate90 ? 90 : 0) - facing.method_10144()));
        matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
        matrices.method_22907(class_1160.field_20703.method_23214(this.rotation));
        matrices.method_22904((double)((this.startX - 8.0f) / 16.0f), (double)(-this.startY / 16.0f + 0.0f * this.maxHeight / (float)this.maxArrivals / 16.0f), (double)((this.startZ - 8.0f) / 16.0f - 0.00625f));
        matrices.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        if (pidsPreset.image != null) {
            matrices.method_22903();
            class_4588 vertexConsumerPIDSBG = vertexConsumers.getBuffer(MoreRenderLayers.getLight((class_2960)pidsPreset.image, (boolean)false));
            matrices.method_22904(0.0, -1.0, 0.01);
            RenderLCDPIDS.drawTexture(matrices, vertexConsumerPIDSBG, this.startX - 10.5f, -1.5f, 111.0f, 60.0f, facing, -1, 0xF000F0);
            matrices.method_22909();
        }
        matrices.method_22909();
        if (RenderTrains.shouldNotRender((class_2338)pos, (int)Math.min(16, RenderTrains.maxTrainRenderDistance), (class_2350)(this.rotate90 ? null : facing))) {
            return;
        }
        try {
            Set schedules;
            long platformId = RailwayData.getClosePlatformId((Set)ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE, (class_2338)pos);
            if (platformId == 0L) {
                schedules = new HashSet();
            } else {
                Set schedulesForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platformId);
                Set set = schedules = schedulesForPlatform == null ? new HashSet() : schedulesForPlatform;
            }
            if (pidsPreset.onlyShowLastRow) {
                hideArrivals = new boolean[]{true, true, true, false};
            }
            int textColor = pidsPreset.color == null ? this.defaultTextColor : pidsPreset.color;
            String textFont = pidsPreset.font == null ? defaultFont : pidsPreset.font;
            ArrayList scheduleList = new ArrayList(schedules);
            Collections.sort(scheduleList);
            int maxCars = 0;
            int minCars = Integer.MAX_VALUE;
            for (ScheduleEntry scheduleEntry : scheduleList) {
                int trainCars = scheduleEntry.trainCars;
                if (trainCars > maxCars) {
                    maxCars = trainCars;
                }
                if (trainCars >= minCars) continue;
                minCars = trainCars;
            }
            boolean showCarLength = minCars != maxCars;
            class_327 textRenderer = class_310.method_1551().field_1772;
            int entryIndex = 0;
            for (int i = 0; i < this.maxArrivals; ++i) {
                boolean useCustomMessage;
                Object destinationString;
                Route route;
                int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 80;
                ScheduleEntry currentSchedule = entryIndex < scheduleList.size() ? (ScheduleEntry)scheduleList.get(entryIndex) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (entryIndex < scheduleList.size() && !hideArrivals[i] && route != null) {
                    destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[i].isEmpty()) {
                        destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                        useCustomMessage = false;
                    } else {
                        String[] customMessageSplit = customMessages[i].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        if (indexToUse < destinationMaxIndex) {
                            destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                            useCustomMessage = false;
                        } else {
                            destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                            useCustomMessage = true;
                        }
                    }
                } else {
                    destinationSplit = customMessages[i].split("\\|");
                    destinationString = destinationSplit[languageTicks % destinationSplit.length];
                    useCustomMessage = true;
                }
                matrices.method_22903();
                matrices.method_22904(0.5, 0.0, 0.5);
                matrices.method_22907(class_1160.field_20705.method_23214((float)(this.rotate90 ? 90 : 0) - facing.method_10144()));
                matrices.method_22907(class_1160.field_20707.method_23214(180.0f));
                matrices.method_22904((double)((this.startX - 8.0f) / 16.0f), (double)(-this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f), (double)((this.startZ - 8.0f) / 16.0f - 0.00625f));
                matrices.method_22905(1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f));
                if (useCustomMessage) {
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, this.screenWidth, 4.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont, textFont);
                } else {
                    int seconds = (int)((currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000L);
                    boolean isCJK = IGui.isCjk((String)destinationString);
                    class_5250 arrivalText = seconds >= 60 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min"), (Object[])new Object[]{seconds / 60}) : (seconds > 0 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.mtr.arrival_sec"), (Object[])new Object[]{seconds}) : null);
                    class_5250 carText = Text.translatable((String)(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car"), (Object[])new Object[]{currentSchedule.trainCars});
                    if (this.showPlatforms) {
                        class_4588 vertexConsumerStationCircle = vertexConsumers.getBuffer(MoreRenderLayers.getLight((class_2960)new class_2960("mtr:textures/sign/circle.png"), (boolean)true));
                        Platform platform = (Platform)ClientData.DATA_CACHE.platformIdMap.get(platformId);
                        if (platform != null) {
                            List platformRouteDetails = ClientData.DATA_CACHE.requestPlatformIdToRoutes(platform.id);
                            this.routeData = platformRouteDetails == null ? new ArrayList() : platformRouteDetails;
                            float x = this.destinationStart + this.destinationMaxWidth;
                            int routeColor = this.routeData.isEmpty() ? 0 : this.routeData.get((int)0).routeColor;
                            RenderLCDPIDS.drawTexture(matrices, vertexConsumerStationCircle, x, 0.0f, 4.0f, 4.0f, facing, routeColor + -16777216, 0xF000F0);
                            matrices.method_22903();
                            matrices.method_22904((double)(x + 1.95f), (double)2.2f, -0.05);
                            matrices.method_22905(0.7f, 0.7f, 0.7f);
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, platform.name, 0.0f, 0.0f, 4.0f, 3.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, true, textFont, textFont);
                            matrices.method_22909();
                        }
                    }
                    matrices.method_22903();
                    matrices.method_22904((double)this.destinationStart, 0.0, 0.0);
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, this.destinationMaxWidth, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont, textFont);
                    matrices.method_22909();
                    if (arrivalText != null) {
                        matrices.method_22903();
                        boolean isShowCar = showCarLength && (languageTicks % 6 == 0 || languageTicks % 6 == 1);
                        matrices.method_22904((double)this.screenWidth, 0.0, 0.0);
                        if (isShowCar) {
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, carText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont, textFont);
                        } else {
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, arrivalText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont, textFont);
                        }
                        matrices.method_22909();
                    }
                }
                matrices.method_22909();
                if (hideArrivals[i]) continue;
                ++entryIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

