/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.render;

import com.jsblock.block.PIDSBase;
import com.jsblock.block.PIDSRVBase;
import com.jsblock.client.JobanCustomResources;
import com.jsblock.config.ClientConfig;
import com.jsblock.data.PIDSPreset;
import mtr.block.BlockPIDSBase;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_824;

public abstract class RenderPIDSBase<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui {
    private final int maxArrivals;
    public static final int SWITCH_LANGUAGE_TICKS = 80;
    public static final int MAX_VIEW_DISTANCE = 16;

    public RenderPIDSBase(class_824 dispatcher, int maxArrivals) {
        super(dispatcher);
        this.maxArrivals = maxArrivals;
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        int i;
        class_1937 world = entity.method_10997();
        if (world == null || ClientConfig.getRenderDisabled()) {
            return;
        }
        if (!(entity instanceof PIDSBase.TileEntityBlockJobanPIDS)) {
            return;
        }
        String[] customMessages = new String[this.maxArrivals];
        boolean[] hideArrivals = new boolean[this.maxArrivals];
        for (i = 0; i < this.maxArrivals; ++i) {
            customMessages[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getMessage(i);
            hideArrivals[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getHideArrival(i);
        }
        boolean hidePlatforms = entity instanceof PIDSRVBase.TileEntityBlockRVPIDS ? ((PIDSRVBase.TileEntityBlockRVPIDS)((Object)entity)).getHidePlatformNumber() : false;
        for (i = 0; i < customMessages.length; ++i) {
            customMessages[i] = RenderPIDSBase.parseVariable(customMessages[i], world);
        }
        String presetID = ((PIDSBase.TileEntityBlockJobanPIDS)((Object)entity)).getPresetID();
        PIDSPreset preset = JobanCustomResources.PIDSPreset.getOrDefault(presetID, null);
        try {
            this.render(entity, world, customMessages, hideArrivals, hidePlatforms, preset, tickDelta, matrices, vertexConsumers, light, overlay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void render(T var1, class_1937 var2, String[] var3, boolean[] var4, boolean var5, PIDSPreset var6, float var7, class_4587 var8, class_4597 var9, int var10, int var11);

    public static String parseVariable(String str, class_1937 world) {
        String weatherString;
        long time = world.method_8532() + 6000L;
        long hours = time / 1000L;
        long minutes = Math.round((double)(time - hours * 1000L) / 16.8);
        String timeString = String.format("%02d:%02d", hours % 24L, minutes % 60L);
        String string = world.method_8419() ? "Raining" : (weatherString = world.method_8546() ? "Thundering" : "Sunny");
        String weatherChinString = world.method_8419() ? "\u4e0b\u96e8" : (world.method_8546() ? "\u96f7\u66b4" : "\u6674\u5929");
        int worldPlayer = world.method_18456().size();
        String timeGreetings = time >= 6000L & time <= 12000L ? "Morning" : (time >= 12000L & time <= 18000L ? "Afternoon" : "Night");
        return str.replace("{time}", timeString).replace("{weather}", weatherString).replace("{time_period}", timeGreetings).replace("{weatherChin}", weatherChinString).replace("{worldPlayer}", String.valueOf(worldPlayer));
    }

    static void drawTexture(class_4587 matrices, class_4588 vertexConsumer, float x, float y, float width, float height, class_2350 facing, int color, int light) {
        IDrawing.drawTexture((class_4587)matrices, (class_4588)vertexConsumer, (float)x, (float)y, (float)0.0f, (float)(x + width), (float)(y + height), (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (class_2350)facing, (int)color, (int)light);
    }
}

