/*
 * Decompiled with CFR 0.152.
 */
package com.jsblock.screen;

import com.jsblock.config.ClientConfig;
import com.jsblock.data.ConfigGuiEntry;
import com.jsblock.data.InlineComponentEntry;
import com.jsblock.data.ScreenAlignment;
import com.jsblock.data.TextLabel;
import com.jsblock.render.PanoramaRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_751;

public class ConfigScreenBase
extends ScreenMapper
implements IGui {
    private double elapsedTime;
    private final List<InlineComponentEntry> inlineComponentList = new ArrayList<InlineComponentEntry>();
    private final List<ConfigGuiEntry> configList = new ArrayList<ConfigGuiEntry>();
    private final PanoramaRenderer panoramaRenderer;
    private final List<TextLabel> customText = new ArrayList<TextLabel>();
    private boolean initalized;
    private static final int TEXT_PADDING = 12;
    private static final int CONFIG_BUTTON_WIDTH = 60;
    private static final int TEXT_FIELD_WIDTH = 100;
    private static final int FINAL_TEXT_HEIGHT = 20;
    private static final int MAX_TEXT_LENGTH = 128;
    public static final int BUTTON_HEIGHT = 20;
    private static final float PANORAMA_OPACITY = 1.0f;
    public static final class_751 CUBE_MAP = new class_751(new class_2960("jsblock", "textures/gui/background/panorama"));
    private static final class_2960 PANORAMA_OVERLAY = new class_2960("textures/gui/title/background/panorama_overlay.png");

    public ConfigScreenBase(TextLabel ... customText) {
        super((class_2561)Text.literal((String)""));
        this.customText.addAll(Arrays.asList(customText));
        this.panoramaRenderer = new PanoramaRenderer(CUBE_MAP, PANORAMA_OVERLAY);
    }

    public class_339 registerConfigRowButton(class_2561 description, class_2561 defaultMessage, Consumer<class_339> onClick) {
        class_4185 button = new class_4185(0, 0, 0, 20, (class_2561)Text.literal((String)""), button1 -> onClick.accept((class_339)button1));
        button.method_25355(defaultMessage);
        this.configList.add(new ConfigGuiEntry(description, (class_339)button, 60, 20));
        return button;
    }

    public void registerInlineRow(InlineComponentEntry ... entries) {
        this.inlineComponentList.addAll(Arrays.asList(entries));
    }

    /*
     * WARNING - void declaration
     */
    protected void method_25426() {
        void var4_7;
        super.method_25426();
        int i = 0;
        int startY = 0;
        for (TextLabel textLabel : this.customText) {
            startY += (int)(textLabel.y * (double)textLabel.scale);
        }
        ArrayList<ConfigGuiEntry> originalList = new ArrayList<ConfigGuiEntry>(this.configList);
        this.configList.clear();
        for (ConfigGuiEntry configGuiEntry : originalList) {
            configGuiEntry.y = startY + 12 + (20 * i++ + 20);
            this.configList.add(configGuiEntry);
            IDrawing.setPositionAndWidth((class_339)configGuiEntry.widget, (int)(this.field_22789 - 20 - 60), (int)configGuiEntry.y, (int)configGuiEntry.widgetWidth);
            this.addDrawableChild(configGuiEntry.widget);
        }
        boolean bl = false;
        while (var4_7 < this.inlineComponentList.size()) {
            InlineComponentEntry inlineComponentEntry = this.inlineComponentList.get((int)var4_7);
            inlineComponentEntry.setAvailableWidth((int)((double)this.field_22789 / 1.25));
            for (int j = 0; j < inlineComponentEntry.widgetList.size(); ++j) {
                class_339 widget = inlineComponentEntry.widgetList.get(j);
                widget.field_22760 = inlineComponentEntry.calculateWidth() * j;
                this.addDrawableChild(widget);
            }
            this.inlineComponentList.set((int)var4_7, inlineComponentEntry);
            ++var4_7;
        }
        if (!this.initalized) {
            this.initalized = true;
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.elapsedTime += (double)delta;
            if (this.field_22787.field_1687 == null) {
                this.renderPanorama(matrices, delta);
            } else {
                this.method_25420(matrices);
            }
            int startY = 0;
            double guiScale = this.field_22787.method_22683().method_4495();
            for (TextLabel component : this.customText) {
                int textWidth = (int)((float)this.field_22793.method_27525((class_5348)component.text) * component.scale);
                Objects.requireNonNull(this.field_22793);
                int textHeight = (int)((double)(9.0f * component.scale) * guiScale);
                int componentX = ScreenAlignment.getX(component.horizontalAlignment, this.field_22789, textWidth);
                int componentY = (int)((double)startY + component.y);
                int animatedFontWidth = (int)Math.min((double)textWidth, this.elapsedTime * 20.0);
                int x1 = 0;
                int x2 = (int)((double)(componentX + animatedFontWidth) * guiScale);
                int y1 = (int)((double)(this.field_22787.method_22683().method_4502() - componentY) * guiScale);
                int y2 = y1 - textHeight;
                matrices.method_22903();
                matrices.method_22904((double)componentX, (double)componentY, 0.0);
                matrices.method_22905(component.scale, component.scale, component.scale);
                RenderSystem.enableScissor((int)x1, (int)y2, (int)x2, (int)y1);
                if (ClientConfig.getDebugModeEnabled()) {
                    class_329.method_25294((class_4587)matrices, (int)0, (int)0, (int)this.field_22789, (int)this.field_22789, (int)-1);
                    this.field_22793.method_30883(matrices, component.text, 0.0f, 0.0f, -16777216);
                } else {
                    this.field_22793.method_30881(matrices, component.text, 0.0f, 0.0f, -1);
                }
                RenderSystem.disableScissor();
                startY = (int)((float)startY + 12.0f * component.scale);
                matrices.method_22909();
            }
            for (ConfigGuiEntry entry : this.configList) {
                ConfigScreenBase.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)entry.text, (int)20, (int)entry.y, (int)-1);
            }
            int inlineRow = 1;
            int bottomPadding = 20;
            for (InlineComponentEntry entry : this.inlineComponentList) {
                int startInlineY = ScreenAlignment.getY(entry.verticalAlignment, this.field_22790, 20) - 20 * this.inlineComponentList.size() - bottomPadding;
                int y = startInlineY + 20 * inlineRow;
                int totalWidth = entry.calculateWidth() * entry.widgetList.size() + 10 * entry.widgetList.size();
                int startX = ScreenAlignment.getX(entry.horizontalAlignment, this.field_22789, totalWidth);
                for (int i = 0; i < entry.widgetList.size(); ++i) {
                    class_339 widget = entry.widgetList.get(i);
                    int buttonX = startX + entry.calculateWidth() * i + 10 * i;
                    IDrawing.setPositionAndWidth((class_339)widget, (int)buttonX, (int)y, (int)entry.calculateWidth());
                }
                ++inlineRow;
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256) {
            this.closeScreen(true);
            return true;
        }
        return super.method_25404(i, j, k);
    }

    public void renderPanorama(class_4587 matrices, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        this.panoramaRenderer.renderPanorama(matrices, this.field_22787, this.field_22789, this.field_22790, 1.0f, delta);
    }

    public void closeScreen(boolean save) {
        if (save) {
            this.onSave();
        }
        super.method_25419();
    }

    public void onSave() {
    }

    protected static class_2561 getBooleanButtonText(boolean state) {
        return Text.translatable((String)(state ? "options.mtr.on" : "options.mtr.off"), (Object[])new Object[0]);
    }
}

